package kochModel.factory;

import kochModel.*;
import lrs.*;
import java.awt.geom.Point2D.Double;

public class BoxFractalFactory extends FractalFactory {
  
  public BoxFractalFactory() {
    
    double onethird = 1.0/3.0;
    double twothird = 2.0/3.0;
    
    Double pA = new Double(0.0, 0.0);
    Double pB = new Double(1.0, 0.0);
    
    Double p0 = new Double(onethird, -onethird/2.0);
    Double p1 = new Double(twothird, -onethird/2.0);
    Double p2 = new Double(twothird, onethird/2.0);
    Double p3 = new Double(onethird, onethird/2.0);
    
    LRStruct<Koch> children = new LRStruct<Koch>();
    children.insertFront(new Koch(p3, p0));
    children.insertFront(new Koch(p2, p3));
    children.insertFront(new Koch(p1, p2));
    children.insertFront(new Koch(p0, p1));
    
    setProto(new Koch(pA, pB, children));
  }
}
